;
; TBBS Emulation Control File
;
; This file is designed to provide emulation of TBBS chat functionality.
; It does not necessarily provide all the features of TBBS's chat, but it
; does provide all the common functionality in as close a presentation as
; possible.
;
; ----- HEADER ------------------------------------------------------
;
; ** CHANGE FOR YOUR OWN NEEDS **
;
SYSTEM_NAME_TEXT "Test Ultra-Chat System"
SYSTEM_ID_TEXT "UltraTst"
SYSOP_NAME_TEXT "The SysOp"
TBBS_PARSER
UCHAT_DIR SLASHT
;
; ----- STYLE AND GENERAL -------------------------------------------
;
MIN_CHANNEL_NUM 1
MAX_CHANNEL_NUM 40
UCHAT_DIR SLASHT
LIST_ME_SWITCH NO
;
; ----- TBBS STYLE COMMANDS -----------------------------------------
;
; Private message send
;
PRIVATE#01_CMD  /S          MODE=ABCDHI PARTIAL       ;/SEND
   PRIVATE#01_REMOTE  "(%RLINE:+02%:%RHANDLE%, Pvt Msg) %RMSG%^M"
   PRIVATE#01_CONFIRM "Message sent to line %RLINE:+02%^M"
   PRIVATE#01_NAMEPMT "Which line number? "
   PRIVATE#01_MSGPMT  "Enter up to 2 lines of text to send to line %RLINE:+02%:^M^M"
   PRIVATE#01_NOCHAT  "Sorry, but that user has asked not to be disturbed.^M"
   PRIVATE#01_ERROR   "That user cannot be interrupted right now.^M"
;
; Ignore command
;
INTERACT#03_CMD /I          MODE=BCDHI  PARTIAL       ;/IGNORE
   INTERACT#03_ON     "%RHANDLE% is being ignored.^M"
   INTERACT#03_OFF    "%RHANDLE% is no longer being ignored.^M"
   INTERACT#03_ALLON  "You are now ignoring all other users.^M"
   INTERACT#03_ALLOFF "You are no longer ignoring any users.^M"
;
; One on one chat
;
CHAT#01_CMD     /P          MODE=ABCDHI PARTIAL       ;/PRIVATE
   CHAT#01_PROMPT "Which line number? "
   CHAT#01_EXIT "(%RLINE:+02%:%RHANDLE%) Leaving ...^M"
   CHAT#01_REMOTE "^G%RHANDLE%: Would you like to join me for chat?^M
      +        Press C from the menu to go to chat, or enter  /P,%RLINE:+02%  if already in chat.^M"
   CHAT#01_CONFIRM "%RHANDLE% has been notified of your request to chat.^M"
   CHAT#01_NOCHAT "Sorry, but that user has asked not to be disturbed.^M"
   CHAT#01_SELF "Sorry, but you can't do that to yourself.^M"
;
; Change channels
;
CHANNEL#01_CMD  /C          MODE=CDHI   PARTIAL       ;/CHANNEL
   CHANNEL#01_CHANPMT "Which CHANNEL would you like (%MINCHANNEL%-%MAXCHANNEL%)? "
   CHANNEL#01_BADNUM  "CB Channel number out of range %MINCHANNEL%-%MAXCHANNEL% - channel not changed.^M"
   CHANNEL#01_NOTNUM  "Invalid number entered - channel not changed.^M"
   CHANNEL#01_ENTRY   "(%RLINE:+02%:%RHANDLE%) Entering ...^M"
   CHANNEL#01_EXIT    "(%RLINE:+02%:%RHANDLE%) Leaving ...^M"
   CHANNEL#01_CONFIRM "Now on Channel %CHANNEL:2%^M/HELP for help, and /QUIT to exit^M^M"
;
; Handle change
;
EDIT#04_CMD     /N          MODE=ABCDHI PARTIAL       ;/NAME
   EDIT#04_PROMPT  "Please type your new handle EXACTLY the way you want others to see it:^M"
   EDIT#04_CONFIRM "Your new handle is '%HANDLE%'.^M"
   EDIT#04_ERROR   "That handle is already in use, or is the actual name of another user.^M"
;
; Who commands
;
WHO#01_CMD      /WHO,       MODE=ABCDHI PARTIAL EXACT ;/WHO,S
WHO#01_CMD      /WH,        MODE=ABCDHI PARTIAL EXACT ;/WHO,S
WHO#01_CMD      /W,         MODE=ABCDHI PARTIAL EXACT ;/WHO,S
WHO#01_CMD      /W          MODE=CH    PARTIAL EXACT ;/WHO
   WHO#01_HEADER "Callers currently on system^M^M"
   WHO#01_NORMAL " Line:%RLINE:+02%  %RHANDLE% ; %RLOCATION% (%RCOMMAND%)^M"
;
; Who on channel
;
WHO#07_CMD      /W          MODE=BDI   PARTIAL EXACT ;/WHO
   WHO#07_PUBLIC "Other callers in conference:^M^M"
   WHO#07_PRIVATE "%HANDLE% is now in private chat with %RHANDLE% on line %RLINE:+02%^M"
   WHO#07_NOUSERS "No other callers in conference.^M^M"
   WHO#07_NORMAL " %RLINE:+02%  %RHANDLE% ; %RLOCATION%^M"
;
; Exit chat
;
EXIT#02_CMD     /Q          MODE=B    PARTIAL EXACT ;/QUIT
;
; Exit channel
;
CHANNEL#07_CMD  /Q          MODE=CD   PARTIAL EXACT ;/QUIT
   CHANNEL#07_ENTRY   "(%RLINE:+02%:%RHANDLE%) Entering ...^M"
   CHANNEL#07_EXIT    "(%RLINE:+02%:%RHANDLE%) Leaving ...^M"
   CHANNEL#07_CONFIRM "Conference joined: %CHANNEL%^M/HELP for help, and /QUIT to exit^M^M"
;
; Exit chat
;
EXIT#01_CMD     /Q          MODE=HI   PARTIAL EXACT ;/QUIT
;
; Help file display
;
HELP#01_CMD     /H          MODE=ABCDHI PARTIAL EXACT ;/HELP
   HELP#01_FILE  TBBSHELP.TXT
   HELP#01_ERROR "Help file not found!^M"
;
; Three-line bio commands
;
BIO#01_PROMPT "Before you proceed, you MUST fill out the three line bio.  The
      +    | more interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines) of
      +    | text to use.  Do not press <Enter> until you are done!  Word
      +    | wrapping happens automatically.  Start typing: ^M^M"

BIO#02_PROMPT "You are about to change your three line bio.  The more 
      +    | interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines)
      +    | of text to use.  Do not press <Enter> until you are done!
      +    |  Word wrapping happens automatically.  Start typing: ^M^M"

BIO#02_YN   "Are you sure you want to change your three line bio (Y/N)? "
;
;
;
CHAT#02_TEXT =WHO#11_TEXT
;
; Define "Bad command input" error message.
;
ERROR#01_TEXT "Invalid command!  Type /H for Help.^M"
;
; Define "Account not logged on" error message.
;
ERROR#02_TEXT "No one on that line.^M"
;
; Define "Tried to use "WHO" command while invisible" error message.
;
ERROR#04_TEXT "Who commands are not allowed while you are invisible.^M"
;
; Define "Tried to chat/send private message to NOCHAT user" error message.
;
ERROR#05_TEXT "Sorry, but that user has asked not to be disturbed.^M"
;
; Define "User tried to do invalid operation to self" error message.
;
ERROR#06_TEXT "Sorry, but you can't do that to yourself.^M"
;
; Define "No queued messages" message for /QD.
;
MISC#01_TEXT "No  /S  messages waiting for you.^M"
;
; Define "Press any key" message.
;
MISC#02_TEXT "-Press Any Key to Continue-"
;
; Define format of public chat messages.
;
CHAT#01_TEXT "(%RLINE:+02%:%RHANDLE%) %RMSG%^M"
;
; Public message prefix
;
CHAT#23_TEXT "^M"
;
; Waiting on user logged off
;
CHAT#24_TEXT "^MThe user you are waiting for is no longer logged on, exiting wait mode.^M"
;
; Define message when entering chat if people are waiting for user.
;
CHAT#03_TEXT "The following user(s) are waiting to chat with you:^M^M"
;
; Define prompt when entering chat if one person is waiting for user.
;
CHAT#04_TEXT "Would you like to go into private chat with this user [Y/N]? "
;
; Define prompt when entering chat if multiple people are waiting for user.
;
CHAT#05_TEXT "Enter the line number of the person that you wish to chat with,
      +    | or C to enter chat with someone else: "
;
; Define prompt when entering chat if no one is waiting for user.
;
CHAT#06_TEXT "Enter the line number of the person that you wish to chat with,
      +    | P for public chat with everyone, S for sysop, or X to exit: "
;
; Define prompt asking user if he/she wants to wait for the other user.
;
CHAT#07_TEXT "^MDo you wish to wait for the other user [Y/N]? "
;
; Define message telling user they are waiting for the other user.
;
CHAT#08_TEXT "^MYou are now waiting for the other user.  A period will appear
      +      | every 5 seconds while you wait.  Press the <ENTER> key at any
      +      | time to stop waiting for the other user.^M^M"
;
; Define message telling user the other user left private chat.
;
CHAT#09_TEXT "^M^MThe other person left private chat.  You are exiting chat now.^M^M"
;
; Define message telling user a private chat has started.
;
CHAT#10_TEXT "Private conference entered.^M%RHANDLE% waiting to chat with you.^MUse /Q to quit.^M^M"
;
; Define message telling user they are in public chat.
;
CHAT#11_TEXT "^MConference joined: %CHANNEL%^M/HELP for help, and /QUIT to exit^M^M"
;
; Define private chat prompt.
;
CHAT#12_TEXT "P%RLINE:+02%: "
;
; Define message sent to remote users when user enters from other than another
; channel.
;
CHAT#14_TEXT "(%RLINE:+02%:%RHANDLE%) Entering ...^M"
;
; Define message sent to remote users when user leaves for other than another
; channel.
;
CHAT#15_TEXT "(%RLINE:+02%:%RHANDLE%) Leaving ...^M"
;
; Define message sent to remote users when user leaves for another channel.
;
CHAT#19_TEXT =CHAT#15_TEXT
;
; Banner file on entry to public chat
;
MISC#09_TEXT "^[[0;1;37mWelcome to %VERSION% in TBBS emulation mode!^M^M"
